/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.api.level;

import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.PonderWorldParticles;
import com.zurrtum.create.client.ponder.foundation.level.PonderChunk;
import com.zurrtum.create.content.logistics.depot.EjectorItemEntity;
import com.zurrtum.create.ponder.api.VirtualBlockEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5455;
import net.minecraft.class_703;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PonderLevel
extends SchematicLevel {
    @Nullable
    public PonderScene scene;
    protected Map<class_2338, class_2680> originalBlocks = new HashMap<class_2338, class_2680>();
    protected Map<class_2338, class_2487> originalBlockEntities = new HashMap<class_2338, class_2487>();
    protected Map<class_2338, Integer> blockBreakingProgressions = new HashMap<class_2338, Integer>();
    protected List<class_1297> originalEntities = new ArrayList<class_1297>();
    @Nullable
    private Long2ObjectMap<PonderChunk> chunks;
    protected PonderWorldParticles particles = new PonderWorldParticles(this);
    int overrideLight;
    @Nullable
    Selection mask;
    boolean currentlyTickingEntities;

    public PonderLevel(class_2338 anchor, class_1937 original) {
        super(anchor, original);
        this.renderMode = true;
    }

    public void createBackup() {
        this.originalBlocks.clear();
        this.originalBlockEntities.clear();
        this.originalBlocks.putAll(this.blocks);
        class_5455 registryManager = this.method_30349();
        this.blockEntities.forEach((k, v) -> this.originalBlockEntities.put((class_2338)k, v.method_38242((class_7225.class_7874)registryManager)));
        this.entities.forEach(e -> {
            try (class_8942.class_11340 logging = new class_8942.class_11340(e.method_71370(), Ponder.LOGGER);){
                class_11362 writeView = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)registryManager);
                e.method_5662((class_11372)writeView);
                class_11368 readView = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)registryManager, (class_2487)writeView.method_71475());
                class_1299.method_5892((class_11368)readView, (class_1937)this, (class_3730)class_3730.field_52444).ifPresent(this.originalEntities::add);
            }
        });
    }

    public void restore() {
        this.entities.clear();
        this.blocks.clear();
        this.blockEntities.clear();
        this.blockBreakingProgressions.clear();
        this.renderedBlockEntities.clear();
        this.blocks.putAll(this.originalBlocks);
        class_5455 registryManager = this.method_30349();
        this.originalBlockEntities.forEach((k, v) -> {
            class_2586 blockEntity = class_2586.method_11005((class_2338)k, (class_2680)this.originalBlocks.get(k), (class_2487)v, (class_7225.class_7874)registryManager);
            this.onBEAdded(blockEntity, blockEntity.method_11016());
            this.blockEntities.put(k, blockEntity);
            this.renderedBlockEntities.add(blockEntity);
        });
        this.originalEntities.forEach(e -> {
            try (class_8942.class_11340 logging = new class_8942.class_11340(e.method_71370(), Ponder.LOGGER);){
                class_11362 writeView = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)registryManager);
                e.method_5662((class_11372)writeView);
                class_11368 readView = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)registryManager, (class_2487)writeView.method_71475());
                class_1299.method_5892((class_11368)readView, (class_1937)this, (class_3730)class_3730.field_52444).ifPresent(this.entities::add);
            }
        });
        this.particles.clearEffects();
        PonderIndex.forEachPlugin(plugin -> plugin.onPonderLevelRestore(this));
    }

    public void restoreBlocks(Selection selection) {
        selection.forEach(p -> {
            class_2586 blockEntity;
            if (this.originalBlocks.containsKey(p)) {
                this.blocks.put(p, this.originalBlocks.get(p));
            }
            if (this.originalBlockEntities.containsKey(p) && (blockEntity = class_2586.method_11005((class_2338)p, (class_2680)this.originalBlocks.get(p), (class_2487)this.originalBlockEntities.get(p), (class_7225.class_7874)this.method_30349())) != null) {
                this.onBEAdded(blockEntity, blockEntity.method_11016());
                this.blockEntities.put(p, blockEntity);
            }
        });
        this.redraw();
    }

    private void redraw() {
        if (this.scene != null) {
            this.scene.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
        }
    }

    public void pushFakeLight(int light) {
        this.overrideLight = light;
    }

    public void popLight() {
        this.overrideLight = -1;
    }

    @Override
    public int method_8314(class_1944 p_226658_1_, class_2338 p_226658_2_) {
        return this.overrideLight == -1 ? 15 : this.overrideLight;
    }

    public void setMask(@Nullable Selection mask) {
        this.mask = mask;
    }

    public void clearMask() {
        this.mask = null;
    }

    @Override
    public class_2680 method_8320(class_2338 globalPos) {
        if (this.mask != null && !this.mask.test(globalPos.method_10059((class_2382)this.anchor))) {
            return class_2246.field_10124.method_9564();
        }
        if (this.currentlyTickingEntities && globalPos.method_10264() < 0) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_8320(globalPos);
    }

    public class_1922 method_22338(int p_225522_1_, int p_225522_2_) {
        return this;
    }

    public void renderEntities(class_4587 ms, class_11659 queue, class_4184 ari, class_12075 cameraRenderState, float pt) {
        class_243 Vector3d2 = ari.method_71156();
        double d0 = Vector3d2.method_10216();
        double d1 = Vector3d2.method_10214();
        double d2 = Vector3d2.method_10215();
        class_310 mc = class_310.method_1551();
        class_898 renderManager = mc.method_1561();
        for (class_1297 entity : this.entities) {
            if (entity.field_6012 == 0) {
                entity.field_6038 = entity.method_23317();
                entity.field_5971 = entity.method_23318();
                entity.field_5989 = entity.method_23321();
            }
            this.renderEntity(renderManager, entity, cameraRenderState, d0, d1, d2, pt, ms, queue);
        }
    }

    private void renderEntity(class_898 renderManager, class_1297 entity, class_12075 cameraRenderState, double x, double y, double z, float pt, class_4587 ms, class_11659 queue) {
        class_10017 state = renderManager.method_72977(entity, pt);
        renderManager.method_72976(state, cameraRenderState, state.field_53325 - x, state.field_53326 - y, state.field_53327 - z, ms, queue);
    }

    public void renderParticles(class_11661 queue, class_4184 ari, class_12075 cameraRenderState, float pt) {
        this.particles.renderParticles(queue, ari, cameraRenderState, pt);
    }

    public void resetParticles() {
        this.particles.resetParticles();
    }

    public void tick() {
        this.currentlyTickingEntities = true;
        this.particles.tick();
        Iterator iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            class_1297 entity = (class_1297)iterator.next();
            ++entity.field_6012;
            entity.field_6038 = entity.method_23317();
            entity.field_5971 = entity.method_23318();
            entity.field_5989 = entity.method_23321();
            entity.method_5773();
            if (entity.method_23318() <= -0.5) {
                entity.method_31472();
            }
            if (entity instanceof EjectorItemEntity) {
                if (!entity.method_31481()) continue;
                iterator.remove();
                continue;
            }
            if (entity.method_5805()) continue;
            iterator.remove();
        }
        this.currentlyTickingEntities = false;
    }

    public void method_8406(class_2394 data, double x, double y, double z, double mx, double my, double mz) {
        this.particles.addParticle(data, x, y, z, mx, my, mz);
    }

    public void method_8494(class_2394 data, double x, double y, double z, double mx, double my, double mz) {
        this.method_8406(data, x, y, z, mx, my, mz);
    }

    public void addParticle(@Nullable class_703 p) {
        if (p != null) {
            this.particles.addParticle(p);
        }
    }

    protected void onBEAdded(class_2586 blockEntity, class_2338 pos) {
        super.onBEadded(blockEntity, pos);
        if (!(blockEntity instanceof VirtualBlockEntity)) {
            return;
        }
        VirtualBlockEntity virtualBlockEntity = (VirtualBlockEntity)blockEntity;
        virtualBlockEntity.markVirtual();
    }

    public void setBlockBreakingProgress(class_2338 pos, int damage) {
        if (damage == 0) {
            this.blockBreakingProgressions.remove(pos);
        } else {
            this.blockBreakingProgressions.put(pos, damage - 1);
        }
    }

    public Map<class_2338, Integer> getBlockBreakingProgressions() {
        return this.blockBreakingProgressions;
    }

    public void addBlockDestroyEffects(class_2338 pos, class_2680 state) {
        class_265 voxelshape = state.method_26218((class_1922)this, pos);
        if (voxelshape.method_1110()) {
            return;
        }
        class_238 bb = voxelshape.method_1107();
        double d1 = Math.min(1.0, bb.field_1320 - bb.field_1323);
        double d2 = Math.min(1.0, bb.field_1325 - bb.field_1322);
        double d3 = Math.min(1.0, bb.field_1324 - bb.field_1321);
        int i = Math.max(2, class_3532.method_15384((double)(d1 / 0.25)));
        int j = Math.max(2, class_3532.method_15384((double)(d2 / 0.25)));
        int k = Math.max(2, class_3532.method_15384((double)(d3 / 0.25)));
        for (int l = 0; l < i; ++l) {
            for (int i1 = 0; i1 < j; ++i1) {
                for (int j1 = 0; j1 < k; ++j1) {
                    double d4 = ((double)l + 0.5) / (double)i;
                    double d5 = ((double)i1 + 0.5) / (double)j;
                    double d6 = ((double)j1 + 0.5) / (double)k;
                    double d7 = d4 * d1 + bb.field_1323;
                    double d8 = d5 * d2 + bb.field_1322;
                    double d9 = d6 * d3 + bb.field_1321;
                    this.method_8406((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + d7, (double)pos.method_10264() + d8, (double)pos.method_10260() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5);
                }
            }
        }
    }

    @Override
    protected class_2680 processBlockStateForPrinting(class_2680 state) {
        return state;
    }

    public boolean method_22340(class_2338 pos) {
        return true;
    }

    public boolean method_33598(int x, int y) {
        return true;
    }

    public boolean method_8477(class_2338 pos) {
        return true;
    }

    public boolean method_18458(double p_217358_1_, double p_217358_3_, double p_217358_5_, double p_217358_7_) {
        return true;
    }

    public class_3965 method_17742(class_3959 context) {
        return (class_3965)class_1922.method_17744((class_243)context.method_17750(), (class_243)context.method_17747(), (Object)context, (innerContext, pos) -> {
            class_2680 blockState = this.method_8320((class_2338)pos);
            class_3610 fluidState = blockState.method_26227();
            class_243 vec3d = innerContext.method_17750();
            class_243 vec3d2 = innerContext.method_17747();
            class_265 voxelShape = innerContext.method_17748(blockState, (class_1922)this, pos);
            class_3965 blockHitResult = this.method_17745(vec3d, vec3d2, (class_2338)pos, voxelShape, blockState);
            class_265 voxelShape2 = innerContext.method_17749(fluidState, (class_1922)this, pos);
            class_3965 blockHitResult2 = voxelShape2.method_1092(vec3d, vec3d2, pos);
            double d = blockHitResult == null ? Double.MAX_VALUE : innerContext.method_17750().method_1025(blockHitResult.method_17784());
            double e = blockHitResult2 == null ? Double.MAX_VALUE : innerContext.method_17750().method_1025(blockHitResult2.method_17784());
            return d <= e ? blockHitResult : blockHitResult2;
        }, innerContext -> {
            class_243 vec3d = innerContext.method_17750().method_1020(innerContext.method_17747());
            return class_3965.method_17778((class_243)innerContext.method_17747(), (class_2350)class_2350.method_10142((double)vec3d.field_1352, (double)vec3d.field_1351, (double)vec3d.field_1350), (class_2338)class_2338.method_49638((class_2374)innerContext.method_17747()));
        });
    }

    public class_2818 method_8497(int x, int z) {
        if (this.chunks == null) {
            this.chunks = new Long2ObjectOpenHashMap();
        }
        return (class_2818)this.chunks.computeIfAbsent(class_1923.method_8331((int)x, (int)z), packedPos -> new PonderChunk(this, class_1923.method_8325((long)packedPos), class_1923.method_8332((long)packedPos)));
    }

    public class_2791 method_8402(int x, int z, class_2806 leastStatus, boolean create) {
        return this.method_8497(x, z);
    }
}

